package com.ejie.ab04b.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.springframework.context.ApplicationContext;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.Tablones;
import com.ejie.ab04b.service.TablonesService;
import com.ejie.ab04b.service.util.ApplicationContextProvider;

/**
 * Clase con los valores de los estados
 * 
 * @author igor
 * 
 */
public final class ResultadoEstudioDocImpl {

	// variable estatica
	private static ResultadoEstudioDocImpl estadosValuesInstance;

	// valores de los estados
	private Map<String, Tablones> values;

	/**
	 * Constructor privado de la clase.
	 */
	private ResultadoEstudioDocImpl() {
		this.values = new HashMap<String, Tablones>();
	}

	/**
	 * Gets the single instance of ResultadoEstudioDocImpl.
	 * 
	 *  EstadosValues
	 *
	 * @return single instance of ResultadoEstudioDocImpl
	 */
	public synchronized static ResultadoEstudioDocImpl getInstance() {

		if (ResultadoEstudioDocImpl.estadosValuesInstance == null
				|| ResultadoEstudioDocImpl.estadosValuesInstance.values
						.isEmpty()) {
			ResultadoEstudioDocImpl.estadosValuesInstance = new ResultadoEstudioDocImpl();

			ApplicationContext ctx = ApplicationContextProvider
					.getApplicationContext();

			TablonesService tablonesService = (TablonesService) ctx
					.getBean("tablonesService");
			Tablones tablones = new Tablones();
			tablones.setCodtabla088(Constantes.TABLON_RESULTADO_ESTUDIO_DOC);
			List<Tablones> listaEstados = tablonesService.findAll(tablones,
					null);

			Tablones tablon;
			Iterator<Tablones> it = listaEstados.iterator();
			while (it.hasNext()) {
				tablon = it.next();
				ResultadoEstudioDocImpl.estadosValuesInstance.values.put(
						tablon.getCodigo088(), tablon);
			} // fin del while

		}

		return ResultadoEstudioDocImpl.estadosValuesInstance;
	}

	/**
	 * Gets the value.
	 * 
	 *  name
	 *            String
	 *  TipoEre
	 *
	 * @param name the name
	 * @return the value
	 */
	public Tablones getValue(String name) {
		return this.values.get(name);
	}

	/**
	 * Gets the values.
	 * 
	 *  List<Tablones>
	 *
	 * @return the values
	 */
	public List<Tablones> getValues() {
		List<Tablones> arr = new ArrayList<Tablones>();
		arr.add(new Tablones());
		arr.addAll(this.values.values());
		return arr;
	}

	/**
	 * Gets the copy.
	 * 
	 *  List<Tablones>
	 *
	 * @return the copy
	 */
	public List<Tablones> getCopy() {
		List<Tablones> listaResult = new ArrayList<Tablones>();
		List<Tablones> listaOriginal = this.getValues();
		for (Tablones obj : listaOriginal) {
			listaResult.add(obj.clonar());
		}
		return listaResult;
	}

}
